'10/09/2013
'This code simulates an Oregon Scientific temperature sensor, type THGR810
'This sensor measures temperature and humidity and trasnmits the data to an Oregon Base using
'433.92 Mhz
'The data is sent in 4 bit nibbles using normal Manchester coding.
'The data rate is 1024 Hz which equals Oregon V3 protocol.
'The OS V3 protocol has assymetrical bit timings.
'The RF message data layout is as follows.
'A preamble of 6 nibbles consisting of all 1.
'A sync nibble of 10.
'Sensor data follows.


'Sensor data is as follows.
'Sensor ID - 4 nibbles, oregon THGR810 has ID of F824
'Sensor rolling code  - 1 nibble
'Sensor battery flag  - 1 nibble
'Sensor temperature  - 3 nibbles format is xx.x deg
'Sensor temperature sign - 1 nibble 0 is positive , non zero is negative.
'Sensor humidity - 2 nibbles = xx%
'1 nibble next of which purpose is unknown.****
'Sensor CRC which is simply arithmetical sum of data from Sensor data to above data ****
'Sensor post amble - 2 nibbles CCitt7 CRC.
'Nibbles are sent in order with the LSB of each nibble sent first.
'Sensor code for THGR810 sensor is F824.
'The transmit time of this sensor depends on what channel its set too'
'Times are
'1   2   3   4   5   6   7   8   9   10   Channel number
'53  59  61  67  71  79  83  87  91  93   Time in seconds
'Transmission times are crystalled controlled and accurate down to 100 us.





'Notes on the DHT22 temp Sensor.
'This Sensor sends 5 bytes of data which are RH1-RH2, Temp1-Temp2, crc
'Rh1-Rh2 is a 16 bit word that is divided by 10 to read XX.X %
'Temp1-Temp2 is a 16 bit word that is divided by 10 to read XX.X D
'If the MSB of Temp1 is 1 , the temp is -, ie below 0D C.
'The CRC is the 8 bit sum the 4 data bytes.

'Notes on the DHT11 Temp Sensor.
'This sensor sends data in the same way as the DHT22, but the data format is differant.
'First byte = RH in decimal, this sensor doesnt send a fractional part, so the 2nd byte
'is always 0.
'Third byte = Temp in Decimal, again no fractional part , so byte 4 is always = 0.
'Some simple averaging is applied to the DHT11 sensor to make the temp readings look a bit better.
'The first 5 temp readings from the DHT11 Sensor should be ignored.

'To conserve battery power As much As possible the power to the Sensor is turned off when its not being read.
'To give the Sensor time to stabilise, power is turned on 6 seconds before a read is taken.
'This mainly for the DHT11 sensor which seems to be a bit power hungry, draws around 150 ua in idle mode.
'The DHT22 is better and only draws 40 ua in idle mode.

'Notes on the OS console.
'The OS Console has a gated receiver which is turned off most of the time.
'It only gets turned on when the console is expecting a sensor to transmit.
'Initialyy when the OS console is reset, the receiver is turned on all the time for around 5 minutes and in this time will receive any sensor
'it hears.
'After the 5 minutes are up the receiver then gets turned on and off at various times depending on how many sensors and what channel they are on
'it has heard in the first 5 minutes.
'The Console receiver is on for a very short time , around 750 ms , so the sensors must transmit at exactly the right time.
'There appears to be some capacity for the Console to track each sensor if its transmission time wanders, but how far it can be off I
'havnt been able to determine.
'OS THGR810 sensors have a 32.768 watch crystal in them to determine timings, so this code also uses a 32.768 crystal to do the same.
'Notes on Data timing.
'The OS console is quite critical in terms of data timings.
'From my investigations , the data pulses need to be within 15 us of what the OS console expects otherwise the transmission is ignored.
'To make things worse, the receiver in the OS console seems to modify the incoming data transmission so that the pulse widths are slightly altered
'from what is being transmitted.
'On or hi pulses get lengthened and lo or off pulses get shortened.
'This means that the data timing for the transmitter has to be altered to make the data timing for the console look right.
'Why they do this and why the data timing is so critical I have no idea.
'To get the timing right its necessary to use the inbuilt timers in the Micro to generate the data timings.
'Timer0 is used to time the data pulses.
'The original idea of just using wait statements which works Ok for WSDL just wont work for the OS console.
'Ive tried this code on WMR100 and WMR80 consoles and both appear to work OK.
'10/09/2013 fixed bug where correct sensor wasnt being detected properly.




AllDigital
Define CLOCK_FREQUENCY = 20  'Crystal frequency.






Dim x1 As Byte
Dim x2 As Byte
Dim x3 As Byte
Dim flags As Byte
Dim syncflag As Byte
Dim channel As Byte
Dim channel_timing As Byte
Dim timer1_loops As Byte
Dim timer1_left As Byte
Dim timer1_last As Word
Dim rollingcode1 As Byte
Dim rollingcode2 As Byte
Dim battflag As Byte
Dim temp1 As Byte
Dim temp2 As Byte
Dim temp3 As Byte
Dim tempsign As Byte
Dim humidity1 As Byte
Dim humidity2 As Byte
Dim sensorid1 As Byte
Dim sensorid2 As Byte
Dim sensorid3 As Byte
Dim sensorid4 As Byte
Dim unknown As Byte
Dim crc As Byte
Dim hum As Word
Dim tmp As Word
Dim tmp1 As Byte
Dim packetbit As Byte
Dim nibble As Byte
Dim nextnibble As Byte
Dim nextbit As Bit

Dim timer1counter As Long

'variables for the CRC calculations.
Dim bitno As Byte
Dim crcpoly As Byte
Dim crcnib1 As Byte
Dim crcnib2 As Byte
Dim crc1nib1 As Byte
Dim crc1nib2 As Byte
Dim crc1calc As Byte

'variables for the random number generator.
Dim t1 As Bit
Dim t2 As Bit
Dim t3 As Bit
Dim restart As Byte




'DHT Sensor variables.
Dim dht_error As Bit
Dim tpacket(5) As Byte
Dim packet As Byte
Dim chksm As Byte
Dim dht11 As Bit
Dim n As Byte
Dim avtemperature(6) As Byte
Dim avcount As Word

'variables for data transmit code.
Dim v1 As Byte
Dim v2 As Byte
Dim v3 As Byte
Dim v4 As Byte
Dim v5 As Byte
Dim v6 As Byte
Dim v7 As Byte
Dim v8 As Byte


For n = 0 To 5  'Load DHT11 Temperature averaging array with 0, only needed for 1st 5 minutes.
	avtemperature(n) = 0
Next n

crcpoly = 7  'Polynomial for CCITT-8 CRC
crc = 0  'this is the initial value used by all OS version 3.0 sensors


dht11 = 0  'Set to 1 for DHT11, set to 0 for DHT22.
TRISA = 0  'All bits op to save power during sleep mode.
TRISB = 0  'All bite op to save power during sleep mode.
PORTA = 0  'Set all ports to output
PORTB = 0

Symbol tx = PORTA.0  'Pin transmitter is connected too.
Symbol led = PORTA.1  'Activity led.
Symbol dhtp = TRISA.3  'this pin needs to be bidirectional
Symbol dht = PORTA.3  'Sensor data pin.
Symbol dhtpower = PORTA.4  'Sensor Vcc pin.
dhtp = 1  'initially set this port to input.Normal state when not reading DHT Sensor.
tx = 0  'Transmitter off






Dim edata(26) As Byte  'array variables 0 - 25 + 1 dummy variable so that the Manchester coding routine works properly.



'Some of the following values get changed later after the sensor is read.
flags = 15
syncflag = 10
sensorid1 = 0xf  'nibble 0
sensorid2 = 0x8  'nibble 1
sensorid3 = 0x2  'nibble 2
sensorid4 = 0x4  'nibble 3
channel = 2  'nibble 4 (THGR810 can use channels 1 to 10, but 1 is normally reserved by outside temp sensor.)
rollingcode1 = 0xb  'nibble 5
rollingcode2 = 0xd  'nibble 6
battflag = 8  'nibble 7
temp1 = 8  'nibble 8 'Temp=23.8
temp2 = 3  'nibble 9
temp3 = 2  'nibble 10
tempsign = 0  'nibble 11 0 for positive value, non zero for negative value
humidity1 = 3  'nibble 12 28%
humidity2 = 5  'nibble 13
unknown = 4  'nibble 14 not known what this data is for.
timer1counter = 65536

'Transmit Data timing values, based on 20 Mhz Crystal.
'Delay time = (256 - v) * 3.2 us
v1 = 119
v2 = 89
v3 = 119
v4 = 117
v5 = 90
v6 = 96
v7 = 89
v8 = 116



T1CON.T1OSCEN = 1  'Turn on the Timer1 external clock oscillator.This is the watch crystal, a very low power oscillator.
T1CON.TMR1CS = 1  'Set clock oscillator as Timer1 Clocking source.
T1CON.2 = 1  'Disable Timer1 clock sync , needed to keep Timer1 running while Micro is asleep.
T1CON.TMR1ON = 0  'Initially stop Timer1
T1CON.T1CKPS1 = 1  'Timer1 prescaler set to 8, gives 4096 ticks per second
T1CON.T1CKPS0 = 1  'Timer1 prescaler set to 8
PIE1.TMR1IE = 1  'Enable Timer1 overflow flag,needed tp wake up the Micro from sleep.
INTCON.PEIE = 1  'Generate interrupt on Timer1 overflow.No actual interrupt ie, vector to 0x0004 occurs, as GIE bit is not set.
'but is needed  To wake up the micro from sleep.
CMCON.CM2 = 1  'Turn off Comparators to reduce power consumption when sleeping.
CMCON.CM1 = 1  '-
CMCON.CM0 = 1  '-

OPTION_REG.PSA = 0  'set TMR0 prescaler to timet 0
OPTION_REG.PS2 = 0  'above
OPTION_REG.PS1 = 1  'above








OPTION_REG.PS0 = 1  'Set TMR0 prescaler to 16,as we need to count in approx 3 us ticks for the DHT Sensor and the Transmit code, this gives 3.2 us ticks.
OPTION_REG.T0CS = 0  'enable tmr0

'Hseropen 19200



led = 1  'Light the led to show something is happening.
WaitMs 2000
led = 0  'Turn the led off.
'Read the channel number and Sensor type.
TRISB.0 = 1  'Set bits 0 - 4 of Ch B to inputs
TRISB.1 = 1  'Read the channel no and the DHT type.
TRISB.2 = 1
TRISB.3 = 1


TRISB.4 = 1  'This bit is for sensor type , 1 = dht11, 0 = dht22

OPTION_REG.7 = 0  'weak pull ups on.Turns on CHB weak pullups.Link in = 0 , Link out = 1.

channel = PORTB And 15  'Read portb 0 - 3
channel = channel + 1  'Channels can be 1 to 10, 1  is reserved for outdoor type temp sensors.
If channel > 10 Then channel = 10
dht11 = PORTB.4  '0 = dht22, 1 = dht11
TRISB = 0  'Set PORTB to output, turns off weak pullups.


For x1 = 1 To channel  'Flash the led to indicate we have started.One flash per channel number.
	WaitMs 500
	led = 1
	WaitMs 500
	led = 0
Next x1



'Simple lookup table, channel_timing returns the channel  value in the table, ie channel = 3 , channel _value = 3rd value starting at 0 ,= 61
channel_timing = LookUp(0, 53, 59, 61, 67, 71, 79, 83, 87, 91, 93), channel  'Periodic Transmission times for each channel in seconds.

'Generate a random number for the rollingcode.
'To make the random number , read the DHT Sensor and multiply the RH by the temp to get the seed for the RNG.
'To make it a bit more random , run the RNG generator multiple times based on the channel number and the number of times
'the batteries have been replaced, this value held in EEPROM and incremented every time the Micro is restarted.
dhtpower = 1
WaitMs 6000  'allow Sensor to stabilise.
Gosub read_dht  'read the temperature and humidity.
tmp = temp3 + temp2 + temp1
tmp1 = humidity2 + humidity1
tmp = tmp * tmp1
Read 1, restart  'Read location 1 in the EEprom.
If restart = 255 Then restart = 0  'Reset to 0 if EEprom value overflows , probably happens anyway.
restart = restart + 1  'Increment restart value.
Write 1, restart  'write new value back to EEprom.
tmp1 = restart + channel
x1 = random_number(tmp, tmp1)  'generate the random number.
rollingcode1 = ShiftRight(x1, 4)
rollingcode2 = x1 And 15




'Calculate Timer1 values.
'Notes. timer1 is a 16 bit timer and we use the overflow flag which goes high when Timer1 goes from 0xFFFF to 0x0000.
'We must transmit data at exactly the right times or the OS console wont receive it.
'To conserve battery power in the Sensor the CPU and the DHT Sensors must be kept in sleep mode as much as possible.
'To keep time whilst the CPU is asleep , Timer1 runs off a 32.768 Khz watch crystal which keeps running all the time.
'The Timer1 prescaler is set to 8 , which with Timer1 being a 16 bit Timer, gives a timing range of 16 seconds.
'As the transmission intervals are greater than 16 seconds, we must count timer1 counts multiple times.
'Timer1_loops sets how many times we must count for 16 seconds, and timer1_last sets how long the last count is , which is always less
'than 16 seconds.
'Timer1 takes 16 seconds to overflow , ie 4096 counts per second, so preloaded value into Timer1 = 65536 - (timer1_left * 4096)
'The power to the DHT Sensor must be turned on at least 6 seconds before we try to read data.
'So the timing routine must allow for the 6 seconds needed to power up the DHT Sensor.
channel_timing = channel_timing - 6  'Reduce initial wait time by 6 seconds to allow for Sensor on time.
timer1_loops = channel_timing / 16  'numcer of timer to count to 16
timer1_left = channel_timing Mod 16  'whats left
timer1_last = (timer1counter - (timer1_left * 4096)) / 256  'Timer1 is preloaded with this vzlue


'Datasheet recommends setting low byte of timer1 to 0, b4 loading hi byte, then load lo byte.
T1CON.TMR1ON = 0  'Preload Timer1 with 0
TMR1L = 0
TMR1H = 0
TMR1L = 0
T1CON.TMR1ON = 1  'Start Timer1

start:  'Main Loop.

'This code here sets the transmission timing for each channel.
'The Timer1 overflow interrupt must be disabled immediately after sleep, and re enabled after the overflow flag has been cleared.
'-----------------------------------------------------------------
For x1 = 1 To timer1_loops  'This loop counts 16 second sleep times.
	ASM:        sleep  'sleeps the Micro to reduce battery drain.
	PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt
	PIR1.TMR1IF = 0  'clear Timer1 overflow flag
	PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.
Next x1

PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt.
T1CON.TMR1ON = 0  'stop timer1, needs to be stopped to preload new values.
TMR1L = 0
TMR1H = timer1_last  'load Timer1 with remaining time count.This counts the remainder of the sleep time.
TMR1L = 0
T1CON.TMR1ON = 1  'start timer1
PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.
ASM:        sleep

PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt
PIR1.TMR1IF = 0  'clear Timer1 overflow flag
T1CON.TMR1ON = 0  'Stop timer1
TMR1L = 0
TMR1H = 160  'Preload Timer1 with 6 seconds .(65536 - (4096 * 6))/256
TMR1L = 0
dhtpower = 1  'turn on the Sensor power.
T1CON.TMR1ON = 1  'start timer1
PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.

ASM:        sleep  'We sleep for 6 seconds to allow the Sensor to stabilse.
PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt
PIR1.TMR1IF = 0  'clear Timer1 overflow flag
PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.


'--------------------------------------------------------------------

Gosub read_dht  'Read the Temp / Hum data.

transmit:  'Here we load the data array and Transmit the data.
For x1 = 0 To 5  'Store flags in array.
edata(x1) = flags
Next x1


edata(6) = syncflag  'Store Syncflag in Array

edata(7) = sensorid1  'Store sensor ID
edata(8) = sensorid2
edata(9) = sensorid3
edata(10) = sensorid4

edata(11) = channel  'Sensor Channel

edata(12) = rollingcode1  'sensor rolling code
edata(13) = rollingcode2

edata(14) = battflag  'Battery flag

edata(15) = temp1  'Send temperature LSB first
edata(16) = temp2
edata(17) = temp3
edata(18) = tempsign  '0=Indicates a positive temp,1= negative

edata(19) = humidity1  'send humidity. LSB first
edata(20) = humidity2
edata(21) = unknown

Gosub calc_crc1  'Calculate the first crc.
edata(22) = crc1nib1  '1st normal modulo8 CRC.
edata(23) = crc1nib2

Gosub crc2calc  'calculate the 2nd CRC
edata(24) = crcnib1  'End 2nd crc.
edata(25) = crcnib2
edata(26) = 0  'dummy data to allow the nibble look ahead to work properly.

'We start transmitting here.
led = 1  'Light the Led
WaitMs 1
INTCON.TMR0IF = 1  'This routine user TMR0 to do the data timing.
'This routine encodes a 4 bit nibble into Manchester format.
'Due to the odd timings that OS3 sensors use, its necessary to look at what the next bit is when encoding the current bit.
For x1 = 0 To 25  '26 variables to send.
	nibble = edata(x1)
		For x2 = 0 To 3  '4 bits per nibble to send.We need to look ahead to the next nibble when the current nibble bit is MSB.
				If x2 = 3 Then
					x3 = x1 + 1
					nextnibble = edata(x3)  'need To look at Next Bit when sending current bit
					nextbit = nextnibble.0  'next bit is either in current nibble , or is in next nibble.
				Else
					nextbit = nibble.1
				Endif
'This is the bit that does the hard work.
'Dont fool with the delay times , unless you really know what you are doing.
		If nibble.0 = 1 Then
					'1 followed by 1  short hi - short lo
				If nextbit = 1 Then
					Call delay(1, v1)  'wait 438
					Call delay(0, v2)  'wait 534
				Else  '1 followed by 0 Long Lo  - short hi - long lo
					Call delay(1, v3)  'wait 438 us
					Call delay(0, v4)  'wait 444 us
				Endif
		Else
				
			If nextbit = 1 Then  '0 followed by 1 ,Long Hi   short lo - long hi
				Call delay(0, v5)  'wait 531
				Call delay(1, v6)  'wait 512 us
			Else  ''0 followed by 0   short lo - short hi
				Call delay(0, v7)  'wait 534 us
				Call delay(1, v8)  'wait 448 us
			Endif
		Endif
		nibble = ShiftRight(nibble, 1)  'Shift nibble one bit right to get next bit.
	Next x2
Next x1
tx = 0
led = 0
Goto start

End                                               
'This process times the data pulses.
'We enter with timer0 preloaded with a value and counting up at 1 tick every 3.2 us.
'The Timer0 overflow flag will normally be 0 and gets set to 1 when the timer overflows from 0xFF to 0x00.
'The OS console has tight data timing requirements and using simple wait statements makes the process unreliable.

Proc delay(txstate As Bit, timer0_time As Byte)  'user Timer0 to generate the data pulses.
While INTCON.TMR0IF = 0  'wait for Timer0 to overflow
Wend
INTCON.TMR0IF = 0  'clear the overflow flag
tx = txstate  'set the transmitter state
TMR0 = timer0_time  'load the timer for next time period.
End Proc                                          




read_dht:
'Notes on the DHT22 and DHT11 Temp / Humidity sensors.
'These 2 Sensors are made by the same Company and look very similar.
'The DHT22 is the better of the 2 with better temp/humidity range and accuracy.Also is more expensive.
'They both use an identical data format and can be decoded with the same code
'but the meaning of the numbers returned is differant.
'Each sensor sends 4, 8 bit data bytes followed by a 8 bit checksum.
'For DHT11 data returned is simply 1st byte = Humidity, 2nd byte is always 0,3rd byte = temp, 4th byte always 0 , Chksum.
'So if the data returned was 21,0,35,0 - chksum , this means Humidity is 21% and the Temp is 35D.

'For DHT22 data returned is 16 bit number / 10 Humidity, 16 bit number / 10 temperature  -- chkcum.
'So if the data returned is 1 1 2 4 - chksum , this means the Humidity is (256 * 1 + 1) /10 = 25.7% and the Temp is (256 * 2 + 4)/10 = 52.2D
'Note that OS THGR810 Sensors dont send fractional part of the humidity reading,so this value is discarded.
'Its doubtful whether is very accurate anyway.
'This routine uses Timer0 to measure the pulse duration of the sensor, and the tick rate depends on the micro clock and the Timer0 prescaler value.
'If the crystal is changed from 20 Mhz , the timer values will have to be changed also.



'Read the DHT Sensor.

dht_error = 0
'We get here with the DHT data line high, which is the normal state when not reading.
dhtp = 0  'dht port  o/p
dht = 0
WaitMs 20  'send 20 ms low,,wait for DHT to respond
dhtp = 1  'porta i/p

p1: If dht = 1 Then Goto p1  'skip next 3 pulses so we get to the first bit pulse.
p2: If dht = 0 Then Goto p2
p3: If dht = 1 Then Goto p3

For n = 0 To 4  '5 bytes to receive, 4 data bytes plus checksum byte.
	packet = 0

	For packetbit = 1 To 8  '8 bits per data packet
		packet = ShiftLeft(packet, 1)  'accumulate bits To make data Byte

		loop: If dht = 0 Then Goto loop  'Wait for high which is start of data bit.
		TMR0 = 0  'clear timer0
		loop1: If dht = 1 Then Goto loop1  'Wait for low which = end of data bit
		'Timer0 counts in 3.2 us ticks, so we need to discriminate between 70 Us and 28 Us.
		'16 = 50 us , approx 1/2 way between 28 and 70 us
		If TMR0 > 16 Then  'Data 1 = pulse of 70 uS, data 0 = pulse of 28 uS.
			High packet.0  'Set bit 0 of packet to 1
		Else
			Low packet.0  'set bit 0 of packet to 0
		Endif
	Next packetbit
tpacket(n) = packet
Next n
chksm = (tpacket(0) + tpacket(1) + tpacket(2) + tpacket(3))
If tpacket(4) <> chksm Then dht_error = 1  'last 8 bits of packet are checksum

'The 5 data bytes are stored in the tpacket array,
'DHT11 only has resolution of 1D and 1% RH, so we can ignore the fractional bytes (1 and 3) which are always 0.
If dht11 = 1 Then
	hum = tpacket(0)
	humidity2 = hum / 10
	humidity1 = hum Mod 10
	tmp1 = tpacket(2)
	
	tmp = averagetemp(tmp1)  'Gives temp averaged over 5 minutes * 10, done to make the output a little flatter.
	temp3 = tmp / 100
	temp2 = (tmp Mod 100) / 10
	temp1 = (tmp Mod 100) Mod 10
	tempsign = 0
Else
	hum.HB = tpacket(0)
	hum.LB = tpacket(1)
	tmp.HB = tpacket(2)
	tmp.LB = tpacket(3)
	If tmp.15 = 1 Then  'used to indicate negative temp, DHT22 can read from -40C to 80C, DHT11 from 0C to 80C
		tmp.15 = 0
		tempsign = 8  'Set Temp sign for OS data
	Else
		tempsign = 0
	Endif

	temp3 = tmp / 100  'Convert Temp readings to suit OS data format
	temp2 = (tmp Mod 100) / 10
	temp1 = (tmp Mod 100) Mod 10
	humidity2 = hum / 100  'Convert Humidity readings to suit OS data format.
	humidity1 = (hum Mod 100) / 10
	
Endif

If dht_error = 1 Then  'If we get here its most likely the battery is going flat.
	temp1 = 0
	temp2 = 0
	temp3 = 0
	humidity1 = 0
	humidity2 = 0
	battflag = 0
Endif
'Hserout "Temp = ", #temp3, #temp2, ".", #temp1, CrLf

dhtpower = 0  'Turn off the DHT Sensor power to reduce battery drain.
Return                                            

Function averagetemp(avtemp As Byte) As Word
'Calculate rolling average for Temperature over 5 minutes.
'Needed only for the DHT11 Sensor to make its output look a bit more realistic.
'Fuction output is average Temp * 10 to avoid having to use floating point math as it takes too much memory.
'So a temp of 23D will produce 230, 23.1 = 231 etc.


	For x1 = 0 To 3
		x2 = 4 - x1
		x3 = 3 - x1
		avtemperature(x2) = avtemperature(x3)
	Next x1
	avtemperature(0) = avtemp
	avcount = 0
	For x1 = 0 To 4
	avcount = avcount + avtemperature(x1)
	Next x1
	averagetemp = avcount * 2
End Function                                      
'This code provided by Weber from osngr.net
crc2calc:
'BASIC code to compute a CCITT-8 CRC checksum for a nibble-based message

crc = 0
crc = crcnibble(crc, sensorid1)
crc = crcnibble(crc, sensorid2)
crc = crcnibble(crc, sensorid3)
crc = crcnibble(crc, sensorid4)
crc = crcnibble(crc, channel)
crc = crcnibble(crc, rollingcode1)
crc = crcnibble(crc, rollingcode2)
crc = crcnibble(crc, battflag)
crc = crcnibble(crc, temp1)
crc = crcnibble(crc, temp2)
crc = crcnibble(crc, temp3)
crc = crcnibble(crc, tempsign)
crc = crcnibble(crc, humidity1)
crc = crcnibble(crc, humidity2)
crc = crcnibble(crc, unknown)

'at the end, need to run 8 zero bits through to finish the calculation

crc = crcnibble(crc, 0)
crc = crcnibble(crc, 0)

crcnib1 = crc And 15
crcnib2 = ShiftRight(crc, 4)

'now, "encode" these two nibbles after your crc1, crc2 checksum nibbles

Return                                            
'this function adds one more nibble to the crc calculation

Function crcnibble(crc As Byte, nibble As Byte) As Byte

For bitno = 0 To 3
	If crc.7 = 1 Then  'does this return "1" or "8" ? might need "if crc.7 = 8" instead...
		'note: I assume that nibble.3 returns either "0" or "1"
		'if it returns "0" or "8" instead then this code is not correct
		'and you would need another IF statement here to OR a "1" into
		'the left - shifted crc If Bit 3 of nibble is a one
		crc = ShiftLeft(crc, 1)
		If nibble.3 = 1 Then crc = crc Or 1
		If nibble.3 = 0 Then crc = crc Or 0
		crc = crc Xor crcpoly
	Else
		'same comment as above -- depending on what "nibble.3" returns
		crc = ShiftLeft(crc, 1)
		If nibble.3 = 1 Then crc = crc Or 1
		If nibble.3 = 0 Then crc = crc Or 0

	Endif

	nibble = ShiftLeft(nibble, 1)
Next bitno

crcnibble = crc

End Function                                      
calc_crc1:  'Calculate the first crc, simply the modulo8 sum of all the data variables.
crc1calc = sensorid1 + sensorid2 + sensorid3 + sensorid4 + channel + rollingcode1 + rollingcode2 + battflag
crc1calc = crc1calc + temp1 + temp2 + temp3 + tempsign + humidity1 + humidity2 + unknown
crc1nib1 = crc1calc And 15  'Convert single byte into 2 nibbles.
crc1nib2 = ShiftRight(crc1calc, 4)
Return                                            
'Generate a random rumber for the rollingcode.
Function random_number(seed As Word, looptimes As Byte) As Byte
For x1 = 1 To looptimes
	t1 = seed.0 Xor seed.2
	t2 = t1 Xor seed.3
	t3 = t2 Xor seed.5
	seed = ShiftRight(seed, 1)
	seed.15 = t3
	random_number = seed.LB
Next x1
End Function                                      

